! This program calculates occurrence rate of terrestrial planets in the HZ
! using the data from Petigura et al.(2013), PNAS.

implicit none

real *8 koi,period,junk,rprstar,teff,logg,rstar,rp,flux
real *8 semi,mstar,tstar,pbins(13),rbins(12),ci
real *8 p1,p2,p3,p4,p5,nstar,lum,fluxlow,fluxhigh

real *8 f1,f2,f3,f4,f5,f6,f7,f8,f9,f10
real *8 f11,f12,f13,f14,f15,f16,f17,f18,f19,f20
real *8 f21,f22,f23,f24,f25,f26,f27,f28,f29,f30
real *8 f31,f32,f33,f34,f35,f36,f37,f38,f39,f40
real *8 f41,f42,f43,f44,f45,f46,f47,f48
real *8 fN3,fN4,fN7,fN8,fN11,fN12,fN15,fN16,fN19,fN20
real *8 fN23,fN24,fN27,fN28,fN31,fN32,fN35,fN36,fN39,fN40
real *8 fN43,fN44,fN47,fN48
real *8 sumoccr
real *8 seffrg,arg,brg,crg,drg
real *8 seffrv,arv,brv,crv,drv
character(len=3)::disp,prov
integer kicid,counter

open(9,file='Petigura_data')

!*******************************************************
! Fit coefficients for Mass-Teff from Pinnoseault(2012)
!p1 =  -1.129e-14  
!p2 =   -6.922e-12  
!p3 =   5.615e-08  
!p4 =    0.0002821
!p5 =    0.9634
!*******************************************************

nstar = 42557.0d0
counter = 0
sumoccr = 0.0d0

fluxlow = 1.000
fluxhigh = 25.00
!fluxlow = 1.000
!fluxhigh = 4.0d0

seffrv = 1.776
arv    = 2.136e-4
brv    = 2.533e-8
crv    = -1.332e-11
drv    = -3.097e-15

seffrg = 1.107
arg    = 1.332e-4
brg    = 1.580e-8
crg    = -8.308e-12
drg    = -1.931e-15


f1 = 0.0d0
f2 = 0.0d0
f3 = 0.0d0
f4 = 0.0d0
f5 = 0.0d0
f6 = 0.0d0
f7 = 0.0d0
f8 = 0.0d0
f9 = 0.0d0
f10 = 0.0d0
f11 = 0.0d0
f12 = 0.0d0
f13 = 0.0d0
f14 = 0.0d0
f15 = 0.0d0
f16 = 0.0d0
f17 = 0.0d0
f18 = 0.0d0
f19 = 0.0d0
f20 = 0.0d0
f21 = 0.0d0
f22 = 0.0d0
f23 = 0.0d0
f24 = 0.0d0
f25 = 0.0d0
f26 = 0.0d0
f27 = 0.0d0
f28 = 0.0d0
f29 = 0.0d0
f30 = 0.0d0
f31 = 0.0d0
f32 = 0.0d0
f33 = 0.0d0
f34 = 0.0d0
f35 = 0.0d0
f36 = 0.0d0
f37 = 0.0d0
f38 = 0.0d0
f39 = 0.0d0
f40 = 0.0d0
f41 = 0.0d0
f42 = 0.0d0
f43 = 0.0d0
f44 = 0.0d0
f45 = 0.0d0
f46 = 0.0d0
f47 = 0.0d0
f48 = 0.0d0

fN3 = 0.0d0
fN4 = 0.0d0
fN7 = 0.0d0
fN8 = 0.0d0
fN11 = 0.0d0
fN12 = 0.0d0
fN15 = 0.0d0
fN16 = 0.0d0
fN19 = 0.0d0
fN20 = 0.0d0
fN23 = 0.0d0
fN24 = 0.0d0
fN27 = 0.0d0
fN28 = 0.0d0
fN31 = 0.0d0
fN32 = 0.0d0
fN35 = 0.0d0
fN36 = 0.0d0
fN39 = 0.0d0
fN40 = 0.0d0
fN43 = 0.0d0
fN44 = 0.0d0
fN47 = 0.0d0
fN48 = 0.0d0

pbins(1) = 6.25d0
pbins(2) = 9.375d0
pbins(3) = 12.50d0
pbins(4) = 18.75d0
pbins(5) = 25.00d0
pbins(6) = 37.50d0
pbins(7) = 50.00d0
pbins(8) = 75.00d0
pbins(9) = 100.00d0
pbins(10) = 150.0d0
pbins(11) = 200.00d0
pbins(12) = 300.00d0
pbins(13) = 400.00d0

!rbins(1) = 0.50d0
!rbins(2) = 0.75d0
!rbins(3) = 1.0d0
!rbins(4) = 1.5d0
!rbins(5) = 2.0d0
!rbins(6) = 3.0d0
!rbins(7) = 4.0d0
!rbins(8) = 6.0d0
!rbins(9) = 8.0d0
!rbins(10) = 12.0d0
!rbins(12) = 16.0d0

rbins(1) = 0.50d0
rbins(2) = 0.70d0
rbins(3) = 1.0d0
rbins(4) = 1.4d0
rbins(5) = 2.0d0
rbins(6) = 2.8d0
rbins(7) = 4.0d0
rbins(8) = 5.7d0
rbins(9) = 8.0d0
rbins(10) = 11.6d0
rbins(12) = 16.0d0



!print 90
!90 format(4x,'KICID',8x,'PERIOD',8X,'RADIUSP',7X,'RADIUSS',7X,'COMPLETE',7X,&
!           'SEMI',10X,'FLUX',10X,'TEFF')
!90 format(4x,'KOI',8x,'PERIOD',8X,'RADIUSP',7X,'RADIUSS',7X,'COMPLETE',7X,&
!           'SEMI',10X,'FLUX',10X,'TEFF')

print 91
91 format(6x,'KOI',8X,'RADIUSP',10X,'PERIOD',10X,'TEFF',10X,'FLUX')

do while(eof(9)==.false.)
  read(9,*)kicid,koi,period,junk,disp,rprstar,junk,teff,&
           logg,rstar,junk,prov,rp,junk,flux
!***********************************************************************
! !!!!!!!!!!!!!! DISREGARD THIS !!!!!!!!!!!!!!!!!!!!!!!
! Mass estimate could be a source of error because masses are not given.
!  tstar = teff-5780.0
!  mstar = p1*tstar**4 + p2*tstar**3 + p3*tstar**2 + p4*tstar + p5  
!  semi  = (mstar*(period/365)**2)**(1.0d0/3.0d0)
!***********************************************************************


!***********************************************************************
! To find 'a/R*', I need to find 'a' (semi-major axis). Since Petigura et al.
! did not provide masses of the stars, I can not determine 'a' from Kepler's law.
! To determine 'a', I first calculate luminosity and then use the 'flux' incident 
! on the  planet. 'Flux', teff and rstar are given by Petigura et al.(2013).

   lum = (teff/5780)**4*rstar**2
   semi = sqrt(lum/flux)
!   semi = semi - 0.40*semi  ! IF semi-major axis is off by 40%.

   GO TO 110  ! We can skip below 'semi' because we are finding it from the 'flux'

!*****************************************************************
! Since stellar masses are not available, I use stellar masses from 
! Huber et al.(2014), ApJS, 211, 2.
! For KOIs 11462341 & 12121570, NexScI values are used, as Huber et al.
! stellar masses are not available.
!
! The semi-major axis, 'a', determined from luminosity and flux (above),
! and from literature or NexScI differ maximum by 5%. This makes only a 
! change in the third decimal place in the occurrence rate of HZ planets. 

   if(kicid==4912650)then
      mstar = 0.815
!      mstar = mstar-mstar*0.80
      semi = (mstar*(period/365.0d0)**2)**(1.0d0/3.0d0)
!      print *, semi,(mstar*(period/365.0d0)**2)**(1.0d0/3.0d0),&
!               (semi-(mstar*(period/365.0d0)**2)**(1.0d0/3.0d0))/(mstar*(period/365.0d0)**2)**(1.0d0/3.0d0)
   endif
   if(kicid==6225454)then
      mstar = 0.668
!      mstar = mstar-mstar*0.80
      semi = (mstar*(period/365.0d0)**2)**(1.0d0/3.0d0)
!      print *, semi,(mstar*(period/365.0d0)**2)**(1.0d0/3.0d0),&
!               (semi-(mstar*(period/365.0d0)**2)**(1.0d0/3.0d0))/(mstar*(period/365.0d0)**2)**(1.0d0/3.0d0)
   endif
   if(kicid==7877978)then
      mstar = 0.667
!      mstar = mstar-mstar*0.80
      semi = (mstar*(period/365.0d0)**2)**(1.0d0/3.0d0)
!      print *, semi,(mstar*(period/365.0d0)**2)**(1.0d0/3.0d0),&
!               (semi-(mstar*(period/365.0d0)**2)**(1.0d0/3.0d0))/(mstar*(period/365.0d0)**2)**(1.0d0/3.0d0)
   endif
   if(kicid==8183288)then
      mstar = 0.615
!      mstar = mstar-mstar*0.80
      semi = (mstar*(period/365.0d0)**2)**(1.0d0/3.0d0)
!      print *, semi,(mstar*(period/365.0d0)**2)**(1.0d0/3.0d0),&
!               (semi-(mstar*(period/365.0d0)**2)**(1.0d0/3.0d0))/(mstar*(period/365.0d0)**2)**(1.0d0/3.0d0)
   endif
   if(kicid==8611257)then
      mstar = 0.756
!      mstar = mstar-mstar*0.80
      semi = (mstar*(period/365.0d0)**2)**(1.0d0/3.0d0)
!      print *, semi,(mstar*(period/365)**2)**(1.0d0/3.0d0),&
!               (semi-(mstar*(period/365)**2)**(1.0d0/3.0d0))/(mstar*(period/365)**2)**(1.0d0/3.0d0)
   endif
   if(kicid==9447166)then
      mstar = 0.821
!      mstar = mstar-mstar*0.80
      semi = (mstar*(period/365.0d0)**2)**(1.0d0/3.0d0)
!      print *, semi,(mstar*(period/365)**2)**(1.0d0/3.0d0),&
!               (semi-(mstar*(period/365)**2)**(1.0d0/3.0d0))/(mstar*(period/365)**2)**(1.0d0/3.0d0)
   endif
   if(kicid==11462341)then
      mstar = 0.583
!      mstar = mstar-mstar*0.80
      semi = (mstar*(period/365.0d0)**2)**(1.0d0/3.0d0)
!      print *, semi,(mstar*(period/365)**2)**(1.0d0/3.0d0),&
!               (semi-(mstar*(period/365)**2)**(1.0d0/3.0d0))/(mstar*(period/365)**2)**(1.0d0/3.0d0)
   endif
   if(kicid==12121570)then
      mstar = 0.801
!      mstar = mstar-mstar*0.80
      semi = (mstar*(period/365.0d0)**2)**(1.0d0/3.0d0)
!      print *, semi,(mstar*(period/365)**2)**(1.0d0/3.0d0),&
!               (semi-(mstar*(period/365)**2)**(1.0d0/3.0d0))/(mstar*(period/365)**2)**(1.0d0/3.0d0)
   endif

110 CONTINUE

!*****************************************************************
! Remove False positives
    if( (trim(disp)=='SE') .or. (trim(disp)=='VD') .OR. (trim(disp)=='TTV') &
        .OR. (trim(disp)=='V') .OR. (trim(disp)=='C')  )then
        go to 20
           
    endif

!*****************************************************************
! Find the occurrence rate in each Period-radius cell.
! 215.095 is the AU to Rsun conversion factor.
  if(kicid==11462341)then

  endif

  if( (period >= pbins(1)) .and. (period <= pbins(2)) )then
      if((rp >=rbins(1)) .and. (rp<=rbins(2)))then
         ci = 0.04d0
         f1 = f1 + (semi*215.095/(rstar*ci))
         tstar     = teff - 5780.0
         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
           sumoccr = sumoccr + f1
           counter = counter + 1
!           print 100,kicid,rp,flux,teff
            print 100,kicid,koi,rp,period,teff,flux
         endif
      endif
      if((rp >=rbins(2)) .and. (rp<=rbins(3)))then
         ci = 0.21d0
         f2 = f2 + (semi*215.095/(rstar*ci))
         tstar     = teff - 5780.0
         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
           sumoccr = sumoccr + f2
           counter = counter + 1
!           print 100,kicid,rp,flux,teff
            print 100,kicid,koi,rp,period,teff,flux
         endif
      endif

      if((rp >=rbins(3)) .and. (rp<=rbins(4)))then
         ci = 0.66d0
         f3 = f3 + (semi*215.095/(rstar*ci))
         !**********************************************************
         ! This is for HZ planets. If the planets are in between
         ! 1-2 REarth, and if they have appropriate flux (1-4 FEarth),
         ! then find occurrence rate.
         ! There are several other places in the code where this happens.
         tstar     = teff - 5780.0
         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
           sumoccr = sumoccr + f3
           counter = counter + 1
!           print 100,kicid,rp,flux,teff
            print 100,kicid,koi,rp,period,teff,flux
         endif
      endif
      if((rp >=rbins(4)) .and. (rp<=rbins(5)))then
         ci = 0.87d0
         f4 = f4 + (semi*215.095/(rstar*ci))
!         tstar     = teff - 5780.0
!         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
!                        drg*tstar**4
!         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
!           sumoccr = sumoccr + f4
!           counter = counter + 1
!           print 100,kicid,rp,flux,teff
!         endif

      endif

      if((rp >=rbins(5)) .and. (rp<=rbins(6)))then
           ci = 0.93d0
           fN3 = fN3 + (semi*215.095/(rstar*ci))
      endif
      if((rp >=rbins(6)) .and. (rp<=rbins(7)))then
           ci = 0.96d0
           fN4 = fN4 + (semi*215.095/(rstar*ci))
      endif

  endif
  if( (period >= pbins(2)) .and. (period <= pbins(3)) )then
      if((rp >=rbins(1)) .and. (rp<=rbins(2)))then
         ci = 0.05d0
         f5= f5 + (semi*215.095/(rstar*ci))
         tstar     = teff - 5780.0
         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
           sumoccr = sumoccr + f5
           counter = counter + 1
!           print 100,kicid,rp,flux,teff
            print 100,kicid,koi,rp,period,teff,flux
         endif
      endif
      if((rp >=rbins(2)) .and. (rp<=rbins(3)))then
         ci = 0.21d0
         f6 = f6 + (semi*215.095/(rstar*ci))
         tstar     = teff - 5780.0
         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
           sumoccr = sumoccr + f6
           counter = counter + 1
!           print 100,kicid,rp,flux,teff
            print 100,kicid,koi,rp,period,teff,flux
         endif
      endif

      if((rp >=rbins(3)) .and. (rp<=rbins(4)))then
         ci = 0.53d0
         f7 = f7 + (semi*215.095/(rstar*ci))
         tstar     = teff - 5780.0
         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
           sumoccr = sumoccr + f7
           counter = counter + 1
!           print 100,kicid,rp,flux,teff
            print 100,kicid,koi,rp,period,teff,flux
         endif
      endif
      if((rp >=rbins(4)) .and. (rp<=rbins(5)))then
         ci = 0.85d0
         f8 = f8 + (semi*215.095/(rstar*ci))
!         tstar     = teff - 5780.0
!         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
!                        drg*tstar**4
!         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
!           sumoccr = sumoccr + f8
!           counter = counter + 1
!           print 100,kicid,rp,flux,teff
!         endif
      endif
      if((rp >=rbins(5)) .and. (rp<=rbins(6)))then
           ci = 0.92d0
           fN7 = fN7 + (semi*215.095/(rstar*ci))
      endif
      if((rp >=rbins(6)) .and. (rp<=rbins(7)))then
           ci = 0.95d0
           fN8 = fN8 + (semi*215.095/(rstar*ci))
      endif

  endif

  if( (period >= pbins(3)) .and. (period <= pbins(4)) )then
      if((rp >=rbins(1)) .and. (rp<=rbins(2)))then
         ci = 0.03d0
         f9 = f9 + (semi*215.095/(rstar*ci))
         tstar     = teff - 5780.0
         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
           sumoccr = sumoccr + f9
           counter = counter + 1
!           print 100,kicid,rp,flux,teff
            print 100,kicid,koi,rp,period,teff,flux
         endif
      endif
      if((rp >=rbins(2)) .and. (rp<=rbins(3)))then
         ci = 0.12d0
         f10 = f10 + (semi*215.095/(rstar*ci))
         tstar     = teff - 5780.0
         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
           sumoccr = sumoccr + f10
           counter = counter + 1
!           print 100,kicid,rp,flux,teff
            print 100,kicid,koi,rp,period,teff,flux
         endif
      endif

      if((rp >=rbins(3)) .and. (rp<=rbins(4)))then
         ci = 0.47d0
         f11 = f11 + (semi*215.095/(rstar*ci))
         tstar     = teff - 5780.0
         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
           sumoccr = sumoccr + f11
           counter = counter + 1
!           print 100,kicid,rp,flux,teff
            print 100,kicid,koi,rp,period,teff,flux
         endif
      endif
      if((rp >=rbins(4)) .and. (rp<=rbins(5)))then
         ci = 0.75d0
         f12 = f12 + (semi*215.095/(rstar*ci))
!         tstar     = teff - 5780.0
!         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
!                        drg*tstar**4
!         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
!           sumoccr = sumoccr + f12
!           counter = counter + 1
!           print 100,kicid,rp,flux,teff
!         endif
      endif
      if((rp >=rbins(5)) .and. (rp<=rbins(6)))then
           ci = 0.93d0
           fN11 = fN11 + (semi*215.095/(rstar*ci))
      endif
      if((rp >=rbins(6)) .and. (rp<=rbins(7)))then
           ci = 0.96d0
           fN12 = fN12 + (semi*215.095/(rstar*ci))
      endif

  endif

  if( (period >= pbins(4)) .and. (period <= pbins(5)) )then
      if((rp >=rbins(1)) .and. (rp<=rbins(2)))then
         ci = 0.00d0
         f13 = f13 + (semi*215.095/(rstar*ci))
         tstar     = teff - 5780.0
         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
           sumoccr = sumoccr + f13
           counter = counter + 1
!           print 100,kicid,rp,flux,teff
            print 100,kicid,koi,rp,period,teff,flux
         endif
      endif
      if((rp >=rbins(2)) .and. (rp<=rbins(3)))then
         ci = 0.09d0
         f14 = f14 + (semi*215.095/(rstar*ci))
         tstar     = teff - 5780.0
         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
           sumoccr = sumoccr + f14
           counter = counter + 1
!           print 100,kicid,rp,flux,teff
            print 100,kicid,koi,rp,period,teff,flux
         endif
      endif

      if((rp >=rbins(3)) .and. (rp<=rbins(4)))then
         ci = 0.44d0
         f15 = f15 + (semi*215.095/(rstar*ci))
         tstar     = teff - 5780.0
         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
           sumoccr = sumoccr + f15
           counter = counter + 1
!           print 100,kicid,rp,flux,teff
            print 100,kicid,koi,rp,period,teff,flux
         endif
      endif
      if((rp >=rbins(4)) .and. (rp<=rbins(5)))then
         ci = 0.75d0
         f16 = f16 + (semi*215.095/(rstar*ci))
!         tstar     = teff - 5780.0
!         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
!                        drg*tstar**4
!         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
!           sumoccr = sumoccr + f16
!           counter = counter + 1
!           print 100,kicid,rp,flux,teff
!         endif
      endif
      if((rp >=rbins(5)) .and. (rp<=rbins(6)))then
           ci = 0.93d0
           fN15 = fN15 + (semi*215.095/(rstar*ci))
      endif
      if((rp >=rbins(6)) .and. (rp<=rbins(7)))then
           ci = 0.98d0
           fN16 = fN16 + (semi*215.095/(rstar*ci))
      endif

  endif

  if( (period >= pbins(5)) .and. (period <= pbins(6)) )then
      if((rp >=rbins(1)) .and. (rp<=rbins(2)))then
         ci = 0.01d0
         f17 = f17 + (semi*215.095/(rstar*ci))
         tstar     = teff - 5780.0
         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
           sumoccr = sumoccr + f17
           counter = counter + 1
!           print 100,kicid,rp,flux,teff
            print 100,kicid,koi,rp,period,teff,flux
         endif
      endif
      if((rp >=rbins(2)) .and. (rp<=rbins(3)))then
         ci = 0.05d0
         f18 = f18 + (semi*215.095/(rstar*ci))
         tstar     = teff - 5780.0
         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
           sumoccr = sumoccr + f18
           counter = counter + 1
!           print 100,kicid,rp,flux,teff
            print 100,kicid,koi,rp,period,teff,flux
         endif
      endif

      if((rp >=rbins(3)) .and. (rp<=rbins(4)))then
         ci = 0.35d0
         f19 = f19 + (semi*215.095/(rstar*ci))
         tstar     = teff - 5780.0
         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
           sumoccr = sumoccr + f19
           counter = counter + 1
!           print 100,kicid,rp,flux,teff
            print 100,kicid,koi,rp,period,teff,flux
         endif
      endif
      if((rp >=rbins(4)) .and. (rp<=rbins(5)))then
         ci = 0.73d0
         f20 = f20 + (semi*215.095/(rstar*ci))
!         tstar     = teff - 5780.0
!         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
!                        drg*tstar**4
!         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
!           sumoccr = sumoccr + f20
!           counter = counter + 1
!           print 100,kicid,rp,flux,teff
!         endif
      endif
      if((rp >=rbins(5)) .and. (rp<=rbins(6)))then
           ci = 0.88d0
           fN19 = fN19 + (semi*215.095/(rstar*ci))
      endif
      if((rp >=rbins(6)) .and. (rp<=rbins(7)))then
           ci = 0.94d0
           fN20 = fN20 + (semi*215.095/(rstar*ci))
      endif

  endif

  if( (period >= pbins(6)) .and. (period <= pbins(7)) )then
      if((rp >=rbins(1)) .and. (rp<=rbins(2)))then
         ci = 0.00d0
         f21 = f21 + (semi*215.095/(rstar*ci))
         tstar     = teff - 5780.0
         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
           sumoccr = sumoccr + f21
           counter = counter + 1
!           print 100,kicid,rp,flux,teff
            print 100,kicid,koi,rp,period,teff,flux
         endif

      endif
      if((rp >=rbins(2)) .and. (rp<=rbins(3)))then
         ci = 0.06d0
         f22 = f22 + (semi*215.095/(rstar*ci))
         tstar     = teff - 5780.0
         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
           sumoccr = sumoccr + f22
           counter = counter + 1
!           print 100,kicid,rp,flux,teff
            print 100,kicid,koi,rp,period,teff,flux
         endif

      endif

      if((rp >=rbins(3)) .and. (rp<=rbins(4)))then
         ci = 0.30d0
         f23 = f23 + (semi*215.095/(rstar*ci))
         tstar     = teff - 5780.0
         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
           sumoccr = sumoccr + f23
           counter = counter + 1
!           print 100,kicid,rp,flux,teff
            print 100,kicid,koi,rp,period,teff,flux
         endif
      endif
      if((rp >=rbins(4)) .and. (rp<=rbins(5)))then
         ci = 0.73d0
         f24 = f24 + (semi*215.095/(rstar*ci))
!         tstar     = teff - 5780.0
!         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
!                        drg*tstar**4
!         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
!           sumoccr = sumoccr + f24
!           counter = counter + 1
!           print 100,kicid,rp,flux,teff
!         endif
      endif
      if((rp >=rbins(5)) .and. (rp<=rbins(6)))then
           ci = 0.85d0
           fN23 = fN23 + (semi*215.095/(rstar*ci))
      endif
      if((rp >=rbins(6)) .and. (rp<=rbins(7)))then
           ci = 0.92d0
           fN24 = fN24 + (semi*215.095/(rstar*ci))
      endif


  endif

  if( (period >= pbins(7)) .and. (period <= pbins(8)) )then
      if((rp >=rbins(1)) .and. (rp<=rbins(2)))then
         ci = 0.00d0
         f25 = f25 + (semi*215.095/(rstar*ci))
         tstar     = teff - 5780.0
         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
           sumoccr = sumoccr + f25
           counter = counter + 1
!           print 100,kicid,rp,flux,teff
            print 100,kicid,koi,rp,period,teff,flux
         endif

      endif
      if((rp >=rbins(2)) .and. (rp<=rbins(3)))then
         ci = 0.04d0
         f26 = f26 + (semi*215.095/(rstar*ci))
         tstar     = teff - 5780.0
         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
           sumoccr = sumoccr + f26
           counter = counter + 1
!           print 100,kicid,rp,flux,teff
            print 100,kicid,koi,rp,period,teff,flux
         endif

      endif

      if((rp >=rbins(3)) .and. (rp<=rbins(4)))then
         ci = 0.22d0
         f27 = f27 + (semi*215.095/(rstar*ci))
         tstar     = teff - 5780.0
         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
           sumoccr = sumoccr + f27
           counter = counter + 1
!           print 100,kicid,rp,flux,teff
            print 100,kicid,koi,rp,period,teff,flux
         endif
      endif
      if((rp >=rbins(4)) .and. (rp<=rbins(5)))then
         ci = 0.64d0
         f28 = f28 + (semi*215.095/(rstar*ci))
!         tstar     = teff - 5780.0
!         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
!                        drg*tstar**4
!         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
!           sumoccr = sumoccr + f28
!           counter = counter + 1
!           print 100,kicid,rp,flux,teff
!         endif
      endif
      if((rp >=rbins(5)) .and. (rp<=rbins(6)))then
           ci = 0.85d0
           fN27 = fN27 + (semi*215.095/(rstar*ci))
      endif
      if((rp >=rbins(6)) .and. (rp<=rbins(7)))then
           ci = 0.94d0
           fN28 = fN28 + (semi*215.095/(rstar*ci))
      endif

  endif

  if( (period >= pbins(8)) .and. (period <= pbins(9)) )then
      if((rp >=rbins(1)) .and. (rp<=rbins(2)))then
         ci = 0.00d0
         f29 = f29 + (semi*215.095/(rstar*ci))
         tstar     = teff - 5780.0
         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
           sumoccr = sumoccr + f29
           counter = counter + 1
!           print 100,kicid,rp,flux,teff
            print 100,kicid,koi,rp,period,teff,flux
         endif

      endif
      if((rp >=rbins(2)) .and. (rp<=rbins(3)))then
         ci = 0.01d0
         f30 = f30 + (semi*215.095/(rstar*ci))
         tstar     = teff - 5780.0
         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
           sumoccr = sumoccr + f30
           counter = counter + 1
!           print 100,kicid,rp,flux,teff
            print 100,kicid,koi,rp,period,teff,flux
         endif

      endif

      if((rp >=rbins(3)) .and. (rp<=rbins(4)))then
         ci = 0.18d0
         f31 = f31 + (semi*215.095/(rstar*ci))
         tstar     = teff - 5780.0
         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
           sumoccr = sumoccr + f31
           counter = counter + 1
!           print 100,kicid,rp,flux,teff
            print 100,kicid,koi,rp,period,teff,flux
         endif
      endif
      if((rp >=rbins(4)) .and. (rp<=rbins(5)))then
         ci = 0.55d0
         f32 = f32 + (semi*215.095/(rstar*ci))
!         tstar     = teff - 5780.0
!         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
!                        drg*tstar**4
!         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
!           sumoccr = sumoccr + f32
!           counter = counter + 1
!           print 100,kicid,rp,flux,teff
!         endif
      endif
      if((rp >=rbins(5)) .and. (rp<=rbins(6)))then
           ci = 0.83d0
           fN31 = fN31 + (semi*215.095/(rstar*ci))
      endif
      if((rp >=rbins(6)) .and. (rp<=rbins(7)))then
           ci = 0.90d0
           fN32 = fN32 + (semi*215.095/(rstar*ci))
      endif

  endif

  if( (period >= pbins(9)) .and. (period <= pbins(10)) )then
      if((rp >=rbins(1)) .and. (rp<=rbins(2)))then
         ci = 0.00d0
         f33 = f33 + (semi*215.095/(rstar*ci))
      endif
      if((rp >=rbins(2)) .and. (rp<=rbins(3)))then
         ci = 0.01d0
         f34 = f34 + (semi*215.095/(rstar*ci))
      endif

      if((rp >=rbins(3)) .and. (rp<=rbins(4)))then
         ci = 0.10d0
         f35 = f35 + (semi*215.095/(rstar*ci))
!         tstar     = teff - 5780.0
!         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
!                        drg*tstar**4
!         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
!           sumoccr = sumoccr + f35
!           counter = counter + 1
!           print 100,kicid,rp,flux,teff
!         endif
!         print 100,kicid,period,rp,rstar,ci,semi,flux,teff
!         counter = counter + 1
      endif
      if((rp >=rbins(4)) .and. (rp<=rbins(5)))then
         ci = 0.53d0
         f36 = f36 + (semi*215.095/(rstar*ci))
!         tstar     = teff - 5780.0
!         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
!                        drg*tstar**4
!         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
!           sumoccr = sumoccr + f36
!           counter = counter + 1
!           print 100,kicid,rp,flux,teff
!         endif
!         print 100,kicid,period,rp,rstar,ci,semi,flux,teff
!         counter = counter + 1
      endif
      if((rp >=rbins(5)) .and. (rp<=rbins(6)))then
           ci = 0.76d0
           fN35 = fN35 + (semi*215.095/(rstar*ci))
      endif
      if((rp >=rbins(6)) .and. (rp<=rbins(7)))then
           ci = 0.89d0
           fN36 = fN36 + (semi*215.095/(rstar*ci))
      endif

  endif
!100 format(i10,8x,f5.2,5x,f5.2,5x,f6.1)
100 format(i8,3x,4x,f7.2,3x,f5.2,3x,f5.2,3x,f6.1,3x,f4.1)
  if( (period >= pbins(10)) .and. (period <= pbins(11)) )then
      if((rp >=rbins(1)) .and. (rp<=rbins(2)))then
         ci = 0.00d0
         f37 = f37 + (semi*215.095/(rstar*ci))
      endif
      if((rp >=rbins(2)) .and. (rp<=rbins(3)))then
         ci = 0.01d0
         f38 = f38 + (semi*215.095/(rstar*ci))
      endif

      if((rp >=rbins(3)) .and. (rp<=rbins(4)))then
         ci = 0.05d0
         f39 = f39 + (semi*215.095/(rstar*ci))
!         tstar     = teff - 5780.0
!         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
!                        drg*tstar**4
!         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
!           sumoccr = sumoccr + f39
!           counter = counter + 1
!           print 100,kicid,rp,flux,teff
!         endif
!         print 100,kicid,period,rp,rstar,ci,semi,flux,teff
!         counter = counter + 1
      endif
      if((rp >=rbins(4)) .and. (rp<=rbins(5)))then
         ci = 0.34d0
         f40 = f40 + (semi*215.095/(rstar*ci))
!         tstar     = teff - 5780.0
!         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
!                        drg*tstar**4
!         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
!           sumoccr = sumoccr + f40
!           counter = counter + 1
!           print 100,kicid,rp,flux,teff
!         endif
!!         print 100,kicid,period,rp,rstar,ci,semi,flux,teff

!         counter = counter + 1
      endif
      if((rp >=rbins(5)) .and. (rp<=rbins(6)))then
           ci = 0.69d0
           fN39 = fN39 + (semi*215.095/(rstar*ci))
      endif
      if((rp >=rbins(6)) .and. (rp<=rbins(7)))then
           ci = 0.84d0
           fN40 = fN40 + (semi*215.095/(rstar*ci))
      endif

  endif

  if( (period >= pbins(11)) .and. (period <= pbins(12)) )then
      if((rp >=rbins(1)) .and. (rp<=rbins(2)))then
         ci = 0.00d0
         f41 = f41 + (semi*215.095/(rstar*ci))
      endif
      if((rp >=rbins(2)) .and. (rp<=rbins(3)))then
         ci = 0.01d0
         f42 = f42 + (semi*215.095/(rstar*ci))
      endif

      if((rp >=rbins(3)) .and. (rp<=rbins(4)))then
         ci = 0.04d0
         f43 = f43 + (semi*215.095/(rstar*ci))
!         tstar     = teff - 5780.0
!         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
!                        drg*tstar**4
!         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
!           sumoccr = sumoccr + f43
!           counter = counter + 1
!           print 100,kicid,rp,flux,teff
!         endif
      endif
      if((rp >=rbins(4)) .and. (rp<=rbins(5)))then
         ci = 0.25d0
         f44 = f44 + (semi*215.095/(rstar*ci))
!         tstar     = teff - 5780.0
!         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
!                        drg*tstar**4
!         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
!           sumoccr = sumoccr + f44
!           counter = counter + 1
!           print 100,kicid,rp,flux,teff
!         endif
      endif
      if((rp >=rbins(5)) .and. (rp<=rbins(6)))then
           ci = 0.60d0
           fN43 = fN43 + (semi*215.095/(rstar*ci))
      endif
      if((rp >=rbins(6)) .and. (rp<=rbins(7)))then
           ci = 0.78d0
           fN44 = fN44 + (semi*215.095/(rstar*ci))
      endif

  endif
  if( (period >= pbins(12)) .and. (period <= pbins(13)) )then
      if((rp >=rbins(1)) .and. (rp<=rbins(2)))then
         ci = 0.00d0
         f45 = f45 + (semi*215.095/(rstar*ci))
      endif
      if((rp >=rbins(2)) .and. (rp<=rbins(3)))then
         ci = 0.00d0
         f46 = f46 + (semi*215.095/(rstar*ci))
      endif

      if((rp >=rbins(3)) .and. (rp<=rbins(4)))then
         ci = 0.03d0
         f47 = f47 + (semi*215.095/(rstar*ci))
!         tstar     = teff - 5780.0
!         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
!                        drg*tstar**4
!         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
!!           sumoccr = sumoccr + f47
!           counter = counter + 1
!           print 100,kicid,rp,flux,teff
!         endif
      endif
      if((rp >=rbins(4)) .and. (rp<=rbins(5)))then
         ci = 0.13d0
         f48 = f48 + (semi*215.095/(rstar*ci))
!         tstar     = teff - 5780.0
!         fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
!                        drg*tstar**4
!         if((flux >=fluxlow) .and. (flux <=fluxhigh))then
!           sumoccr = sumoccr + f48
!           counter = counter + 1
!           print 100,kicid,rp,flux,teff
!         endif
      endif
      if((rp >=rbins(5)) .and. (rp<=rbins(6)))then
           ci = 0.40d0
           fN47 = fN47 + (semi*215.095/(rstar*ci))
      endif
      if((rp >=rbins(6)) .and. (rp<=rbins(7)))then
           ci = 0.59d0
           fN48 = fN48 + (semi*215.095/(rstar*ci))
      endif

  endif

20 continue  
enddo

print *,'number of Venus analogs ',counter
print *,'eta_Venus for 0.5-1.4 Re is ',sumoccr/nstar
!  print *,(f3+f4+f7+f8)/nstar
!  print *,(f11+f12+f15+f16)/nstar
!  print *,(f19+f20+f23+f24)/nstar
!  print *,(f27+f28+f31+f32)/nstar
!  print *,(f35+f36+f39+f40)/nstar
!  print *,'**********************'
!  print *,(fN3+fN4+fN7+fN8)/nstar
!  print *,(fN11+fN12+fN15+fN16)/nstar
!  print *,(fN19+fN20+fN23+fN24)/nstar
!  print *,(fN27+fN28+fN31+fN32)/nstar
!  print *,(fN35+fN36+fN39+fN40)/nstar

!  print *,counter
close(9)
end
