implicit none

! From Dressing & Charbonneau (2013). arXiv:1302.1647
! 1. KOI 1686.01
! 2. KOI 2418.01
! 3. KOI 854.01
! 4. KOI 2626.01
! 5. KOI 1422.02
! 6. KOI 250.04
! 7. KOI 2650.01
! 8. KOI 886.03
! KID(1) = 6149553
! KID(2) = 10027247
! KID(3) = 6435936
! KID(4) = 11768142
! KID(5) = 11497958
! KID(6) = 9757613
! KID(7) = 8890150
! KID(8) = 7455287

real *8 aRstar,Nstar,eta_Earth_cons,eta_Earth_lib,KOI(8),kkoi(95)
real *8 rrstar,mmstar,pperiod,radiusp(95),flux(95)
real *8 mstar(3900),rstar(3900),period(95),junk,teff(3900),tstar
real *8 seffrg,arg,brg,crg,drg
real *8 seffrv,arv,brv,crv,drv
real *8 fluxlow,fluxhigh,eta_venus,pbins(11),rbins(13)
real *8 rperr1(95),rperr2(95)
integer i,j,flag,KID(95),kkid(3900),counter



open(9,file='stardata')
open(10,file='planetdata')


pbins(1) = 0.68d0
pbins(2) = 1.20d0
pbins(3) = 2.0d0
pbins(4) = 3.4d0
pbins(5) = 5.9d0
pbins(6) = 10.0d0
pbins(7) = 17.0d0
pbins(8) = 29.0d0
pbins(9) = 50.0d0
pbins(10) = 85.0d0
pbins(11) = 146.0d0

rbins(1) = 0.50d0
rbins(2) = 0.70d0
rbins(3) = 1.0d0
rbins(4) = 1.40d0
rbins(5) = 2.0d0
rbins(6) = 2.8d0
rbins(7) = 4.0d0
rbins(8) = 5.7d0
rbins(9) = 8.0d0
rbins(10) = 11.3d0
rbins(11) = 16.0d0
rbins(12) = 22.60d0
rbins(13) = 32.0d0

seffrv = 1.776
arv    = 2.136e-4
brv    = 2.533e-8
crv    = -1.332e-11
drv    = -3.097e-15

seffrg = 1.107
arg    = 1.332e-4
brg    = 1.580e-8
crg    = -8.308e-12
drg    = -1.931e-15

i = 1
 do while(eof(9)==.false.)
    read(9,*)kkid(i),teff(i),junk,junk,rstar(i),junk,junk,mstar(i)
    rstar(i) = rstar(i) * 0.00464913   ! convert solar radius into AU
    i = i + 1
 enddo

print *,'going to planet data'


print 11
11 FORMAT(3x,'KOI',6x,'Rp',5x,' Per',4x,'Teff',6x,'Flux',6x,'etaV',6x,'Nstar')

j = 1
fluxhigh = 25.0
eta_venus = 0.0d0
counter = 0
do while(eof(10)==.false.)
    read(10,*)kkoi(j),KID(j),junk,period(j),junk,junk,junk,&
    radiusp(j),rperr1(j),rperr2(j),flux(j)
!    period(j) = period(j)/365.0d0  ! convert days to years
    if( (period(j)>=pbins(1)) .and. (period(j) <=pbins(2)))then

      if((radiusp(j) >=rbins(1)) .and. (radiusp(j)<=rbins(2)))then
        Nstar = 2484
        do i = 1,3898             
          if(KID(j)==kkid(i))then
            aRstar    = ((mstar(i)*(period(j)/365.0)**2)**(1.0d0/3.0d0))/rstar(j)  
            tstar     = teff(i) - 5780.0
            fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4 
!            fluxlow = seffrv + arv*tstar + brv*tstar**2 + crv*tstar**3 +&
!                      drv*tstar**4 
             if( (flux(j)>=fluxlow) .and. (flux(j)<=fluxhigh))then
               eta_venus =  eta_venus + (aRstar/Nstar) 
               counter   = counter + 1
               print 200,kkoi(j),radiusp(j),rperr1(j),rperr2(j),period(j),&
                         teff(i),flux(j)
             endif
          endif
        enddo
       endif

      if((radiusp(j) >=rbins(2)) .and. (radiusp(j)<=rbins(3)))then
        Nstar = 3546
        do i = 1,3898            
          if(KID(j)==kkid(i))then
            aRstar    = ((mstar(i)*(period(j)/365.0)**2)**(1.0d0/3.0d0))/rstar(j)  
            tstar     = teff(i) - 5780.0
            fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4 
!            fluxlow = seffrv + arv*tstar + brv*tstar**2 + crv*tstar**3 +&
!                      drv*tstar**4 
             if( (flux(j)>=fluxlow) .and. (flux(j)<=fluxhigh))then
               eta_venus =  eta_venus + (aRstar/Nstar) 
               counter   = counter + 1
               print 200,kkoi(j),radiusp(j),rperr1(j),rperr2(j),period(j),&
                         teff(i),flux(j)
             endif
          endif
        enddo
      endif

      if((radiusp(j) >=rbins(3)) .and. (radiusp(j)<=rbins(4)))then
        Nstar = 3831
        do i = 1,3898             
          if(KID(j)==kkid(i))then
            aRstar    =((mstar(i)*(period(j)/365.0)**2)**(1.0d0/3.0d0))/rstar(j)
            tstar     = teff(i) - 5780.0
            fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
!            fluxlow = seffrv + arv*tstar + brv*tstar**2 + crv*tstar**3 +&
!                      drv*tstar**4 
             if( (flux(j)>=fluxlow) .and. (flux(j)<=fluxhigh))then
               eta_venus =  eta_venus + (aRstar/Nstar)
               counter   = counter + 1
               print 200,kkoi(j),radiusp(j),rperr1(j),rperr2(j),period(j),&
                         teff(i),flux(j)
             endif
          endif
        enddo
      endif
     endif

    if( (period(j)>=pbins(2)) .and. (period(j) <=pbins(3)))then
       if((radiusp(j) >=rbins(2)) .and. (radiusp(j)<=rbins(3)))then
        Nstar = 3307
        do i = 1,3898            
          if(KID(j)==kkid(i))then
            aRstar    =((mstar(i)*(period(j)/365.0)**2)**(1.0d0/3.0d0))/rstar(j)
            tstar     = teff(i) - 5780.0
            fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
!            fluxlow = seffrv + arv*tstar + brv*tstar**2 + crv*tstar**3 +&
!                      drv*tstar**4 
             if( (flux(j)>=fluxlow) .and. (flux(j)<=fluxhigh))then
               eta_venus =  eta_venus + (aRstar/Nstar)
               counter   = counter + 1
               print 200,kkoi(j),radiusp(j),rperr1(j),rperr2(j),period(j),&
                         teff(i),flux(j)
             endif
          endif
        enddo
       endif

       if((radiusp(j) >=rbins(3)) .and. (radiusp(j)<=rbins(4)))then
        Nstar = 3764
        do i = 1,3898             
          if(KID(j)==kkid(i))then
            aRstar    =((mstar(i)*(period(j)/365.0)**2)**(1.0d0/3.0d0))/rstar(j)
            tstar     = teff(i) - 5780.0
            fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
!            fluxlow = seffrv + arv*tstar + brv*tstar**2 + crv*tstar**3 +&
!                      drv*tstar**4 
             if( (flux(j)>=fluxlow) .and. (flux(j)<=fluxhigh))then
               eta_venus =  eta_venus + (aRstar/Nstar)
               counter   = counter + 1
               print 200,kkoi(j),radiusp(j),rperr1(j),rperr2(j),period(j),&
                         teff(i),flux(j)
             endif
          endif
        enddo
       endif     
    endif

    if( (period(j)>=pbins(3)) .and. (period(j) <=pbins(4)))then
       if((radiusp(j) >=rbins(1)) .and. (radiusp(j)<=rbins(2)))then
        Nstar = 1374
        do i= 1,3898              
          if(KID(j)==kkid(i))then
            aRstar    =((mstar(i)*(period(j)/365.0)**2)**(1.0d0/3.0d0))/rstar(j)
            tstar     = teff(i) - 5780.0
            fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
!            fluxlow = seffrv + arv*tstar + brv*tstar**2 + crv*tstar**3 +&
!                      drv*tstar**4 
             if( (flux(j)>=fluxlow) .and. (flux(j)<=fluxhigh))then
               eta_venus =  eta_venus + (aRstar/Nstar)
               counter   = counter + 1
               print 200,kkoi(j),radiusp(j),rperr1(j),rperr2(j),period(j),&
                         teff(i),flux(j)
             endif
          endif
        enddo
       endif

       if((radiusp(j) >=rbins(2)) .and. (radiusp(j)<=rbins(3)))then
        Nstar = 2918
        do i = 1,3898            
          if(KID(j)==kkid(i))then
            aRstar    =((mstar(i)*(period(j)/365.0)**2)**(1.0d0/3.0d0))/rstar(j)
            tstar     = teff(i) - 5780.0
            fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
!            fluxlow = seffrv + arv*tstar + brv*tstar**2 + crv*tstar**3 +&
!                      drv*tstar**4 
             if( (flux(j)>=fluxlow) .and. (flux(j)<=fluxhigh))then
               eta_venus =  eta_venus + (aRstar/Nstar)
               counter   = counter + 1
               print 200,kkoi(j),radiusp(j),rperr1(j),rperr2(j),period(j),&
                         teff(i),flux(j)
             endif
          endif
        enddo
       endif

       if((radiusp(j) >=rbins(3)) .and. (radiusp(j)<=rbins(4)))then
        Nstar = 3658
        do i = 1,3898            
          if(KID(j)==kkid(i))then
            aRstar    =((mstar(i)*(period(j)/365.0)**2)**(1.0d0/3.0d0))/rstar(j)
            tstar     = teff(i) - 5780.0
            fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
!            fluxlow = seffrv + arv*tstar + brv*tstar**2 + crv*tstar**3 +&
!                      drv*tstar**4 
             if( (flux(j)>=fluxlow) .and. (flux(j)<=fluxhigh))then
               eta_venus =  eta_venus + (aRstar/Nstar)
               counter   = counter + 1
               print 200,kkoi(j),radiusp(j),rperr1(j),rperr2(j),period(j),&
                         teff(i),flux(j)
             endif
          endif
        enddo
       endif
     endif

     if( (period(j)>=pbins(4)) .and. (period(j) <=pbins(5)))then
       if((radiusp(j) >=rbins(2)) .and. (radiusp(j)<=rbins(3)))then
        Nstar = 2361
        do i = 1,3898            
          if(KID(j)==kkid(i))then
            aRstar    =((mstar(i)*(period(j)/365.0)**2)**(1.0d0/3.0d0))/rstar(j)
            tstar     = teff(i) - 5780.0
            fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
!            fluxlow = seffrv + arv*tstar + brv*tstar**2 + crv*tstar**3 +&
!                      drv*tstar**4 
             if( (flux(j)>=fluxlow) .and. (flux(j)<=fluxhigh))then
               eta_venus =  eta_venus + (aRstar/Nstar)
               counter   = counter + 1
               print 200,kkoi(j),radiusp(j),rperr1(j),rperr2(j),period(j),&
                         teff(i),flux(j)
             endif
          endif
        enddo
       endif
     
       if((radiusp(j) >=rbins(3)) .and. (radiusp(j)<=rbins(4)))then
        Nstar = 3505
        do i = 1,3898            
          if(KID(j)==kkid(i))then
            aRstar    =((mstar(i)*(period(j)/365.0)**2)**(1.0d0/3.0d0))/rstar(j)
            tstar     = teff(i) - 5780.0
            fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
!            fluxlow = seffrv + arv*tstar + brv*tstar**2 + crv*tstar**3 +&
!                      drv*tstar**4 
             if( (flux(j)>=fluxlow) .and. (flux(j)<=fluxhigh))then
               eta_venus =  eta_venus + (aRstar/Nstar)
               counter   = counter + 1
               print 200,kkoi(j),radiusp(j),rperr1(j),rperr2(j),period(j),&
                         teff(i),flux(j)
             endif
          endif
        enddo
       endif
      endif
  
     if( (period(j)>=pbins(5)) .and. (period(j) <=pbins(6)))then
       if((radiusp(j) >=rbins(2)) .and. (radiusp(j)<=rbins(3)))then
        Nstar = 1797
        do i = 1,3898             
          if(KID(j)==kkid(i))then
            aRstar    =((mstar(i)*(period(j)/365.0)**2)**(1.0d0/3.0d0))/rstar(j)
            tstar     = teff(i) - 5780.0
            fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
!            fluxlow = seffrv + arv*tstar + brv*tstar**2 + crv*tstar**3 +&
!                      drv*tstar**4 
             if( (flux(j)>=fluxlow) .and. (flux(j)<=fluxhigh))then
               eta_venus =  eta_venus + (aRstar/Nstar)
               counter   = counter + 1
               print 200,kkoi(j),radiusp(j),rperr1(j),rperr2(j),period(j),&
                         teff(i),flux(j)
             endif
          endif
        enddo
       endif
   
       if((radiusp(j) >=rbins(3)) .and. (radiusp(j)<=rbins(4)))then
        Nstar = 3260
        do i = 1,3898             
          if(KID(j)==kkid(i))then
            aRstar    =((mstar(i)*(period(j)/365.0)**2)**(1.0d0/3.0d0))/rstar(j)
            tstar     = teff(i) - 5780.0
            fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
!            fluxlow = seffrv + arv*tstar + brv*tstar**2 + crv*tstar**3 +&
!                      drv*tstar**4 
             if( (flux(j)>=fluxlow) .and. (flux(j)<=fluxhigh))then
               eta_venus =  eta_venus + (aRstar/Nstar)
               counter   = counter + 1
               print 200,kkoi(j),radiusp(j),rperr1(j),rperr2(j),period(j),&
                         teff(i),flux(j)
             endif
          endif
        enddo
       endif
     endif

     if( (period(j)>=pbins(6)) .and. (period(j) <=pbins(7)))then
       if((radiusp(j) >=rbins(2)) .and. (radiusp(j)<=rbins(3)))then
        Nstar = 1307
        do i = 1,3898            
          if(KID(j)==kkid(i))then
            aRstar    =((mstar(i)*(period(j)/365.0)**2)**(1.0d0/3.0d0))/rstar(j)
            tstar     = teff(i) - 5780.0
            fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
!            fluxlow = seffrv + arv*tstar + brv*tstar**2 + crv*tstar**3 +&
!                      drv*tstar**4 
             if( (flux(j)>=fluxlow) .and. (flux(j)<=fluxhigh))then
               eta_venus =  eta_venus + (aRstar/Nstar)
               counter   = counter + 1
               print 200,kkoi(j),radiusp(j),rperr1(j),rperr2(j),period(j),&
                         teff(i),flux(j)
             endif
          endif
        enddo
       endif
 
      if((radiusp(j) >=rbins(3)) .and. (radiusp(j)<=rbins(4)))then
        Nstar = 2866
        do i = 1,3898            
          if(KID(j)==kkid(i))then
            aRstar    =((mstar(i)*(period(j)/365.0)**2)**(1.0d0/3.0d0))/rstar(j)
            tstar     = teff(i) - 5780.0
            fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
!            fluxlow = seffrv + arv*tstar + brv*tstar**2 + crv*tstar**3 +&
!                      drv*tstar**4 
             if( (flux(j)>=fluxlow) .and. (flux(j)<=fluxhigh))then
               eta_venus =  eta_venus + (aRstar/Nstar)
               counter   = counter + 1
               print 200,kkoi(j),radiusp(j),rperr1(j),rperr2(j),period(j),&
                         teff(i),flux(j)
             endif
          endif
        enddo
       endif
     endif

     if( (period(j)>=pbins(7)) .and. (period(j) <=pbins(8)))then
       if((radiusp(j) >=rbins(2)) .and. (radiusp(j)<=rbins(3)))then
        Nstar = 872
        do i = 1,3898            
          if(KID(j)==kkid(i))then
            aRstar    =((mstar(i)*(period(j)/365.0)**2)**(1.0d0/3.0d0))/rstar(j)
            tstar     = teff(i) - 5780.0
            fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
!            fluxlow = seffrv + arv*tstar + brv*tstar**2 + crv*tstar**3 +&
!                      drv*tstar**4 
             if( (flux(j)>=fluxlow) .and. (flux(j)<=fluxhigh))then
               eta_venus =  eta_venus + (aRstar/Nstar)
               counter   = counter + 1
               print 200,kkoi(j),radiusp(j),rperr1(j),rperr2(j),period(j),&
                         teff(i),flux(j)
             endif
          endif
        enddo
       endif

       if((radiusp(j) >=rbins(3)) .and. (radiusp(j)<=rbins(4)))then
        Nstar = 2336
        do i = 1,3898            
          if(KID(j)==kkid(i))then
            aRstar    =((mstar(i)*(period(j)/365.0)**2)**(1.0d0/3.0d0))/rstar(j)
            tstar     = teff(i) - 5780.0
            fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
!            fluxlow = seffrv + arv*tstar + brv*tstar**2 + crv*tstar**3 +&
!                      drv*tstar**4 
             if( (flux(j)>=fluxlow) .and. (flux(j)<=fluxhigh))then
               eta_venus =  eta_venus + (aRstar/Nstar)
               counter   = counter + 1
               print 200,kkoi(j),radiusp(j),rperr1(j),rperr2(j),period(j),&
                         teff(i),flux(j)
             endif
          endif
        enddo
       endif
     endif

     if( (period(j)>=pbins(8)) .and. (period(j) <=pbins(9)))then
       if((radiusp(j) >=rbins(3)) .and. (radiusp(j)<=rbins(4)))then
        Nstar = 1822
        do i = 1,3898            
          if(KID(j)==kkid(i))then
            aRstar    =((mstar(i)*(period(j)/365.0)**2)**(1.0d0/3.0d0))/rstar(j)
            tstar     = teff(i) - 5780.0
            fluxlow   = seffrg + arg*tstar + brg*tstar**2 + crg*tstar**3 +&
                        drg*tstar**4
!            fluxlow = seffrv + arv*tstar + brv*tstar**2 + crv*tstar**3 +&
!                      drv*tstar**4 
             if( (flux(j)>=fluxlow) .and. (flux(j)<=fluxhigh))then
               eta_venus =  eta_venus + (aRstar/Nstar)
               counter   = counter + 1
               print 200,kkoi(j),radiusp(j),rperr1(j),rperr2(j),period(j),&
                         teff(i),flux(j)
             endif
          endif
        enddo
       endif
     endif


   j =j + 1
enddo
print *,'number of Venus analogs ',counter
print *,'eta_Venus for 0.5-1.4 Re is ',eta_venus

100 format(f7.2,1x,i8,1x,f6.3,1x,f6.3)
200 format(f7.2,3x,f5.2,3x,f5.2,3x,f5.2,3x,f5.2,3x,f6.1,3x,f5.2)



close(9)
close(10)
end
